/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

"use strict";

(function () {
    // includes
    var JSXRunner           = require("./JSXRunner"),
        CEPconnection       = require("./lib/CEPconnection"),
        ConnectionManager   = require("./lib/ConnectionManager"),
        DocumentInfo        = require("./lib/DocumentInfo"),
        ImageGenerator      = require("./lib/ImageGenerator"),
        SubscriptionManager = require("./lib/SubscriptionManager"),
        logger              = require("./logger"),
        Preferences         = require("./lib/Preferences");

    // globals
    var _generator = null;

    // initialize the plugin
    function init(generator, config, genLogger) {
        _generator = generator;

        logger.init(false);

        // load plug-in preferences
        Preferences.init(_generator).then(function() {
            JSXRunner._init(_generator);
            ConnectionManager.init();
            SubscriptionManager.init();
            DocumentInfo.init(_generator);
            ImageGenerator.init(_generator, genLogger);
            CEPconnection.init(_generator);
        });
    }

    exports.init = init;
}());
